#### 1. Overview of Supported VPN Technologies

- **Two main technologies for remote-access VPNs:**
    - **IPsec:**
        - Provides direct and full access to internal resources.
        - Commonly used for site-to-site VPNs.
    - **SSL (TLS/DTLS):**
        - Enables granular control over connections.
        - Preferred for remote-access VPNs due to better firewall/proxy traversal.
- **Transmission protection methods:**
    - **TLS/DTLS** (for SSL VPN)
    - **IPsec** (for IPsec VPN)
- Both methods offer strong cryptographic protection.

---

#### 2. Remote-Access VPN Deployment Types

- **Cisco Clientless SSL VPN**
    - Access via web browser; no client software installation required.
    - Supported only on Cisco Secure Firewall ASA (up to version 9.16; removed in 9.17+).
    - Not available on Cisco Secure Firewall Threat Defense.
- **Cisco Secure Client Full-Tunnel VPN**
    - Requires Cisco Secure Client (formerly AnyConnect) with AnyConnect VPN module.
    - Supports both SSL (TLS/DTLS) and IPsec tunnels.
    - Available on both ASA and Threat Defense platforms.
- **Deployment options:**
    - Clientless SSL VPN (browser-based)
    - Client-based SSL VPN (full-tunnel)
    - Client-based IPsec VPN (full-tunnel)

---

#### 3. Clientless SSL VPN

**Key Features:**

- Users access resources using only a web browser.
- No desktop VPN client installation or admin rights required.
- Suitable for unmanaged devices (partners, contractors, kiosks).
- Web portal provides access to:
    - Web-based applications
    - CIFS file shares
    - FTP servers
    - Applications using static TCP ports (via plug-ins/smart tunnels)
- Uses native TLS encryption (over TCP port 443), easily traverses firewalls/NAT devices.

**Benefits:**

- Easy to deploy and use from any internet-enabled device.
- No software or configuration needed on the remote device.
- Granular access to specific resources, improving security control.

**Limitations:**

- Limited to certain application types (mainly web-based).
- May require user training.
- Not suitable for low-latency or real-time applications.
- No direct access to internal network resources.

**Additional Notes:**

- Deprecated on ASA version 9.17+.
- Not available on Threat Defense appliances.
- URL rewriting affects user ability to verify sites.
- URL entry and rewrite can be disabled if desired.
- Portal allows for bookmarks and protocol-specific navigation.

---

#### 4. Cisco Secure Client VPN (Full-Tunnel)

**Key Features:**

- Requires Cisco Secure Client (AnyConnect VPN module).
- Provides full, direct access to all internal network resources.
- Supports both SSL (TLS/DTLS) and IPsec (IKEv2/ESP) tunnels.
- Available for both ASA and Threat Defense platforms.
- Creates a virtual network interface with IP assignment.
- Allows use of any application as if the user is in the office.
- Supports split tunneling and policy-based access.

**Authentication & Security:**

- Mutual authentication (client and gateway).
- User authentication via certificates or external AAA.
- Authorization and accounting enforced per session.

**Additional Notes:**

- Only IKEv2 supported for IPsec; IKEv1 not supported.
- Threat Defense requires Cisco Secure Client; no third-party IPsec software supported.
- Modular client: includes endpoint security, posture checks, and encryption.
- Available for PC and mobile devices.

---

#### 5. IPsec and SSL Usage Comparison

- **IPsec:**
    - Ideal for site-to-site VPNs (e.g., HQ to branch office).
    - May be blocked by firewalls as ESP packets lack port numbers.
- **SSL (TLS/DTLS):**
    - Preferred for remote-access VPNs (employees, mobile workers).
    - Traffic uses TCP port 443 (HTTPS), easily passes through firewalls/proxies.
    - More likely to work in restrictive network environments.

---

#### 6. Key Takeaways

- **Clientless SSL VPN** is best for limited, browser-based access from unmanaged devices but is deprecated on newer ASA versions and not available on Threat Defense.
- **Cisco Secure Client VPN** offers complete access, supports more applications, and is required for Threat Defense deployments.
- **SSL/TLS VPNs** are generally preferred for remote-access due to ease of deployment and better firewall compatibility.
- **IPsec** remains dominant for site-to-site VPNs but can be used for remote-access if needed, with required client and protocol support.

---

#### 7. Additional Security and Flexibility

- Cisco Secure Client provides modular security, including:
    - Endpoint integrity checks
    - User and device authentication
    - Encryption and web security
    - Flexible access for both personal and corporate devices